#ifndef OPENGLCANVAS_H
#define OPENGLCANVAS_H

// GLew might not be needed on mac, or if a recent version of OpenGL is present
#ifndef __APPLE__
  #include <GL/glew.h>
  #if (!defined GLEW_VERSION_1_5) || (!defined GL_VERSION_3_1)
    #error GLEW 1.5.2 is required
  #endif
#endif

#define GL_GLEXT_PROTOTYPES 1
#ifdef __APPLE__
  #include<OpenGL/gl.h>
  #include<OpenGL/glu.h>
  #include<Glut/glut.h>
  #include<OpenGL/glext.h>
#else
  //#include <GL/gl.h>
  //#include <GL/glu.h>
  #include <GL/glut.h>
  // is glext really needed?
  //#include <GL/glext.h>
#endif

#include <QGLWidget>
#include <QTimer>
#include <QFile>
#include <QFileDialog>
#include <fcntl.h>
#ifdef _WIN32
  #include <io.h>
#else
  #include <unistd.h>   // for getcwd, getpwuid, getuid
#endif
#include "chronos.h"

extern "C" {
#include <ppm.h>
#include <pm.h>
#include <pam.h>
}

class OpenGLCanvas : public QGLWidget
{
    Q_OBJECT
public:
    explicit OpenGLCanvas(QWidget *parent = 0);

protected:
    void read_config_file();
    void load_image(const char *new_image);
    void initializeGL();
    void resizeGL(int w, int h);
    void paintGL();
    void define_texture_coordinates(float *texCoord, int m, int n, float min_phi, float max_phi, float min_lambda, float max_lambda);
    void vertex_transformation(float *positions, int m, int n, float center_lambda, float center_phi, float fov_rads, float scale);
    void load_sphere_mesh(float *positions, int m, int n);
    float calculate_extent(float fov_rads);
    void define_triangle_indices(unsigned int * indices, int m, int n);
    int getTextureSize(const char * const progname, const char * texturePath);
    void readTextureBytes(const char * const progname, const char * texturePath,unsigned char * textureBytes,int * outImageWidth, int * outImageHeight);
    char *textFileRead(char *fn);
    void setShaders();
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void wheelEvent(QWheelEvent *event);

signals:
    void fps(QString newFPS);
    void fov_changed(int new_fov);
    void max_fov_changed(int new_max_fov);

public slots:
    void change_fov(double f);
    void change_fov(int new_fov);
    void change_fov_max(int new_fov_max);
//    void change_scale(double s);
    void change_center_lambda(double lambda);
    void change_center_phi(double phi);
    void re_center();
    void change_fov_scale_relation(QString name);
    void change_visualization(QString name);
    void change_input_image();
    void slotTimer();

private:
    double fov;
    double fov_max; // the \phi_{max} on the technote
    double scale;
    double center_lambda;
    double center_phi;
    QString fov_scale_relation;
    QString visualization;
    bool auto_fov_max;

    Chronos time_time;
    QTimer time_timer;
    int time_frames;
    double time_start;
    double time_fps;

    unsigned int numberOfIndices;
    unsigned int * triangleIndices;
    float * verticesPositions;
    float * textureCoordinates;
    //float windowWidth;
    //float windowHeight;

    char* shader_dir;
    char* input_image_file;

    // input image size (determined automatically)
    int image_size_x;
    int image_size_y;

    QPoint lastPos; // mouse click position
};

#endif // OPENGLCANVAS_H
