#ifndef OPENGLCANVAS_H
#define OPENGLCANVAS_H

// GLew might not be needed if a recent version of OpenGL is present
#include <GL/glew.h>
#if (!defined GLEW_VERSION_1_5) || (!defined GL_VERSION_3_1)
    #error GLEW 1.5.2 is required
#endif

#define GL_GLEXT_PROTOTYPES 1
#ifdef __APPLE__
  #include<OpenGL/gl.h>
  #include<OpenGL/glu.h>
  #include<Glut/glut.h>
  #include<OpenGL/glext.h>
#else
  #include <GL/gl.h>
  #include <GL/glu.h>
  #include <GL/glut.h>
  #include <GL/glext.h>
#endif

#include <QGLWidget>
#include <QTimer>
#include <QFile>
#include <QFileDialog>
#include <fcntl.h>
#include <unistd.h>
#include "chronos.h"

extern "C" {
#include <ppm.h>
#include <pm.h>
#include <pam.h>
}

class OpenGLCanvas : public QGLWidget
{
    Q_OBJECT
public:
    explicit OpenGLCanvas(QWidget *parent = 0);

protected:
    void load_image(const char *new_image);
    void initializeGL();
    void resizeGL(int w, int h);
    void paintGL();
    void define_texture_coordinates(float *texCoord, int m, int n, float min_phi, float max_phi, float min_lambda, float max_lambda);
    void vertex_transformation(float *positions, int m, int n, float center_lambda, float center_phi, float fov_rads, float scale);
    void load_sphere_mesh(float *positions, int m, int n);
    float calculate_extent(float fov_rads);
    void define_triangle_indices(unsigned int * indices, int m, int n);
    int getTextureSize(const char * const progname, const char * texturePath);
    void readTextureBytes(const char * const progname, const char * texturePath,unsigned char * textureBytes,int * outImageWidth, int * outImageHeight);
    char *textFileRead(char *fn);
    void setShaders();

signals:
    void fps(QString newFPS);

public slots:
    void change_fov(double f);
//    void change_scale(double s);
    void change_center_lambda(double lambda);
    void change_center_phi(double phi);
    void change_fov_scale_relation(QString name);
    void change_visualization(QString name);
    void change_input_image();
    void slotTimer();

private:
    double fov;
    double scale;
    double center_lambda;
    double center_phi;
    QString fov_scale_relation;
    QString visualization;

    Chronos time_time;
    QTimer time_timer;
    int time_frames;
    double time_start;
    double time_fps;

    unsigned int numberOfIndices;
    unsigned int * triangleIndices;
    float * verticesPositions;
    float * textureCoordinates;
    float windowWidth;
    float windowHeight;

};

#endif // OPENGLCANVAS_H
