#ifndef OPENGLCANVAS_H
#define OPENGLCANVAS_H

#include "glincludes.h"
#include <QGLWidget>
#include <QTimer>
#include <QFile>
#include <QFileDialog>
#include <fcntl.h>

#include "chronos.h"

#include "image_read.h"

class OpenGLCanvas:
        public QGLWidget,
        public FileRead
{
    Q_OBJECT
public:
    explicit OpenGLCanvas(QWidget *parent = 0);

protected:
    void read_config_file();
    void load_image(const char *new_image);
    void initializeGL();
    void resizeGL(int w, int h);
    void paintGL();
    void define_texture_coordinates(float *texCoord, int m, int n, float min_phi, float max_phi, float min_lambda, float max_lambda);
    void vertex_transformation(float *positions, int m, int n, float center_lambda, float center_phi, float fov_rads, float scale);
    void load_sphere_mesh(float *positions, int m, int n);
    float calculate_extent(float fov_rads);
    void define_triangle_indices(unsigned int * indices, int m, int n);

private:
    int compute_auto_fov_max(int);
    void compute_scale();

    char *textFileRead(char *fn);
    void setShaders();
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void wheelEvent(QWheelEvent *event);

signals:
    void fps(QString newFPS);
    void fov_changed(int new_fov);
    void max_fov_changed(int new_max_fov);

public slots:
    void automaxbutton(bool);
    void shrinkallbutton(bool);
    void change_fov(double f);
    void change_fov(int new_fov);
    void change_fov_max(int new_fov_max);
    void change_zb_lambda(int new_zb_lambda);
    void change_zb_R(int new_zb_R);
//    void change_scale(double s);
    void change_center_lambda(double lambda);
    void change_center_phi(double phi);
    void re_center();
    void change_fov_scale_relation(QString name);
    void change_visualization(QString name);
    void change_input_image();
    void slotTimer();

private:
    enum FileType get_file_type(const char*);

    double fov;
    double fov_max; // the \phi_{max} on the technote
    double scale;
    double center_lambda;
    double center_phi;
    QString fov_scale_relation;
    QString visualization;
    bool auto_fov_max;
    bool shrink_for_all;
    float zblambda,zbR; // parameters of the Zorin-Barr transformation

    Chronos time_time;
    QTimer time_timer;
    int time_frames;
    double time_start;
    double time_fps;

    unsigned int numberOfIndices;
    unsigned int * triangleIndices;
    float * verticesPositions;
    float * textureCoordinates;
    //float windowWidth;
    //float windowHeight;

    char* shader_dir;
    char* input_image_file;
    char* input_image_dir;

    // input image size
    int image_size_x;
    int image_size_y;

    QPoint lastPos; // mouse click position
};

#endif // OPENGLCANVAS_H
