#ifndef IMAGE_READ_H
#define IMAGE_READ_H

#include <utility>
#include <jpeglib.h>
#include <png.h>

#ifndef _MSC_VER
extern "C" {
#include <ppm.h>
#include <pm.h>
#include <pam.h>
}
  #ifndef _MSC_VER
    #define PROGNAME "pano_interface"
  #endif
#endif

enum FileType{
    JPEG,
    PNG,
    PNM,
    UNKNOWN
};

class FileRead{
    private:
        static enum FileType get_file_type(const char*);
    protected:
        static unsigned char *read_image(const char*,int*,int*);
        static const char *image_types;
    private:
        static unsigned char *jpgRead(const char*,int*,int*);
        static unsigned char *pngRead(const char*,int*,int*);
#ifndef _MSC_VER
        static unsigned char *pnmRead(const char * const,const char*,int*,int*);
#endif
};

#endif // IMAGE_READ_H
