#ifndef FILES_H
#define FILES_H

#ifdef _MSC_VER
  #include <io.h>
  #include <direct.h>
  #define GET_WORKDIR _getcwd
  #define OPEN_FILE _open
  #define LSEEK_FD _lseek
  #define FOPEN_RO(_descriptor,_filename) \
    if(fopen_s(&(_descriptor),_filename,"r")){ \
        fprintf(stderr,"unable to open file '%s'\n",_filename); \
        exit(-1); \
    }
#else
  #include <cstdio>     // for fopen and fclose
  #include <unistd.h>   // for getcwd, getpwuid, getuid
  #define GET_WORKDIR getcwd
  #define OPEN_FILE open
  #define LSEEK_FD lseek
  #define FOPEN_RO(_descriptor,_filename) \
    _descriptor=fopen(_filename,"r"); \
    if((_descriptor)==NULL){ \
        fprintf(stderr,"unable to open file '%s'\n",_filename); \
        exit(-1); \
    }
#endif

#endif // FILES_H
